<div class="ulz-mod-action ulz-mod-action-{{ $type }} ulz-ajaxing" data-type="{{ $type }}">

    @php

        $component->form->render([
            'type' => 'nonce',
            'id' => 'security-action',
            'value' => 'utillz-security-nonce',
        ]);

        $component->form->render([
            'type' => 'hidden',
            'id' => 'listing_id',
            'value' => get_the_ID(),
        ]);

    @endphp

    <div class="ulz-action-price">
        <span class="ulz--price ulz-font-heading">{!! Ucore()->format_price( $price->processing ) !!}</span>
    </div>

    @if( $title )
        <p class="ulz-action-title">{{ $title }}</p>
    @endif

    @if( $description )
        <p class="ulz-action-summary">{!! nl2br( wp_kses_post( html_entity_decode( $description ) ) ) !!}</p>
    @endif

    <div class="ulz-action-purchase">
        <div class="ulz-form">
            <div class="ulz-grid">

                @if( $allow_addons )
                    @php

                        $addon_options = [];
                        $items = Ucore()->jsoning( 'ulz_addons', $listing->id );
                        foreach( $items as $key => $item ) {
                            if( empty( $item->fields->key ) ) {
                            continue;
                        }
                            $addon_price = floatval( $item->fields->price );
                            $addon_name = [
                                $item->fields->name,
                                Ucore()->format_price( $addon_price )
                            ];
                            $addon_options[ $item->fields->key ] = $addon_name;
                        }

                        if( $addon_options ) {
                            $component->form->render([
                                'type' => 'flyout',
                                'id' => 'flyout-addons',
                                'label' => $addon_label,
                                'fields' => [
                                    'addons' => [
                                        'type' => 'checklist',
                                        'name' => $addon_label,
                                        'options' => $addon_options,
                                        'class' => [ 'ulz-mb-0' ]
                                    ]
                                ],
                                'class' => [ 'ulz-mb-2' ]
                            ]);
                        }

                    @endphp
                @endif

            </div>
        </div>

        <div class="ulz-action-pricing">
            {{-- append pricing --}}
        </div>

        <div class="ulz-action-success">
            {{-- append success message --}}
        </div>

        <div class="ulz-action-footer">
            <div class="ulz--action">
                <a href="#"
                    class="ulz-button ulz--large" data-action="purchase">
                    <span>
                        {{ $button_label ? $button_label : $strings->label }}
                    </span>
                    {{ Ucore()->preloader() }}
                </a>
            </div>
        </div>

    </div>
</div>
